/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.TimeProtectionParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.TimeValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;
import java.util.List;

public class WipingRelayPECParameter
extends TimeProtectionParameter {
    static final long serialVersionUID = 0L;
    private int wipingRelayParameterSerializedDataVersion = 1;
    private Timer fBreakTimer;
    private int fCycles;
    private static final String EXTENSION_R_WARNING = "wipingPecR";
    private static final String EXTENSION_DEFAULT = "default";
    private transient String fExtension = null;
    protected static final int RUNNING_BREAK = 10;
    protected static final int RUNNING_PULSE = 11;
    private transient int fRemainingCycles;
    private transient boolean fLastTrigger;
    private transient Timer fCurrentTimer;

    public boolean calculateValue(boolean trigger) {
        boolean result = false;
        if (this.fState == 0 && trigger) {
            this.getTimer().start();
            this.fState = 1;
            result = true;
        }
        if (this.fState == 1) {
            if (!this.getTimer().isFinished()) {
                result = true;
            }
            if (!trigger) {
                this.fState = 2;
            }
        }
        if (this.fState == 2) {
            if (trigger) {
                this.getTimer().start();
                this.fState = 1;
                result = true;
            } else if (this.getTimer().isFinished()) {
                this.fState = 0;
            } else {
                result = true;
            }
        }
        return result;
    }

    public WipingRelayPECParameter() {
    }

    public WipingRelayPECParameter(Block block) {
        super(block);
        this.fParameter = 1;
        this.fData = 1;
        this.fAllocatedTimer = 1;
        this.setParameterNameKeys();
        this.fCycles = 1;
    }

    public String calculateCurrentParameterText() {
        return this.getCurrentTimer().getPassedTime().getTimeAsString();
    }

    public Timer getCurrentTimer() {
        if (this.fCurrentTimer == null) {
            this.fCurrentTimer = this.getTimer();
        }
        return this.fCurrentTimer;
    }

    public boolean calculateValue(boolean trigger, boolean reset) {
        boolean result = false;
        if (reset) {
            this.fState = 0;
            this.getCurrentTimer().reset();
        } else {
            if (trigger && !this.fLastTrigger) {
                this.fState = 0;
            }
            if (this.fState == 0 && trigger && !this.fLastTrigger && (this.getTimer().getParamTime().getMilliseconds() != 0L || this.getBreakTimer().getParamTime().getMilliseconds() != 0L)) {
                this.getBreakTimer().start();
                this.fCurrentTimer = this.getBreakTimer();
                this.fRemainingCycles = this.getCycles();
                this.fState = 10;
            }
            if (this.fState == 10 && this.getBreakTimer().isFinished()) {
                this.getTimer().start();
                this.fCurrentTimer = this.getTimer();
                this.fState = 11;
                result = true;
            }
            if (this.fState == 11) {
                result = true;
                if (this.getTimer().isFinished()) {
                    --this.fRemainingCycles;
                    if (this.getBreakTimer().getParamTime().getMilliseconds() > 0L) {
                        result = false;
                    }
                    if (this.fRemainingCycles > 0) {
                        this.getBreakTimer().start();
                        this.fCurrentTimer = this.getBreakTimer();
                        this.fState = 10;
                    } else {
                        this.fState = 0;
                    }
                }
            }
        }
        this.fLastTrigger = trigger;
        return result;
    }

    public TimeUnit getRestTime() {
        if (this.fState == 11) {
            return this.getTimer().getRemainingTimeForShowing();
        }
        return TimeUnit.getNewTimeObject(this.getTimer().getParamTime().getUnitKey());
    }

    public boolean getValue(boolean trigger, boolean reset) {
        boolean result;
        if (this.getExtension() == EXTENSION_DEFAULT) {
            result = this.calculateValue(trigger);
            this.fCurrentTimer = this.getTimer();
        } else {
            result = this.calculateValue(trigger, reset);
        }
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return result;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.getBreakTimer().init(interpreter);
        if (!this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence() || forceReset) {
            this.getBreakTimer().reset();
            this.fLastTrigger = false;
        }
    }

    protected void setParameterNameKeys() {
        this.getTimer().setNameKey("dialog.parameter.wipingRelayPEC.impulsTime");
    }

    public Timer getBreakTimer() {
        if (this.fBreakTimer == null) {
            this.fBreakTimer = new Timer();
            this.fBreakTimer.setParamTime(0, 0, "dialog.timeParameter.highResolutionSeconds");
            this.fBreakTimer.getParamTimeProperties().setParameter(this);
        }
        return this.fBreakTimer;
    }

    public TimeValueProperties getBreakTime() {
        return this.getBreakTimer().getParamTimeProperties();
    }

    public TimeUnit getBreakTimeRest() {
        if (this.fState == 10) {
            return this.getBreakTimer().getRemainingTimeForShowing();
        }
        return TimeUnit.getNewTimeObject(this.getTimer().getParamTime().getUnitKey());
    }

    public void setBreakTime(TimeValueProperties warningTime) {
        this.getBreakTimer().setParamTime(warningTime.getCurrentValue());
    }

    public Integer getCycles() {
        return this.fCycles;
    }

    public void setCycles(Integer cycles) {
        this.fCycles = cycles;
    }

    public String getParameterText() {
        StringBuffer buffer = new StringBuffer(super.getParameterText());
        if (this.getExtension() == EXTENSION_R_WARNING) {
            buffer.append("\n").append(this.getBreakTimer().getParamTime().getParameterText()).append("\n").append(this.getCycles());
        }
        return buffer.toString();
    }

    private String getExtension() {
        if (this.fExtension == null) {
            try {
                if (this.getBlock().getWiringDiagram().getHardware().supports("comfortSwitchResetWarning")) {
                    this.fExtension = EXTENSION_R_WARNING;
                }
            }
            catch (NullPointerException e) {
                this.fExtension = EXTENSION_DEFAULT;
            }
        }
        return this.fExtension;
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        super.hardwareChanged(hardwareChangedEvent);
        Hardware newHardware = (Hardware)hardwareChangedEvent.getNewValue();
        if (newHardware.supports(EXTENSION_R_WARNING)) {
            this.fExtension = EXTENSION_R_WARNING;
            TimeUnit[] availableTimeUnits = (TimeUnit[])newHardware.getProperty("availableTimeUnits");
            this.getBreakTimer().convertTimerTo(availableTimeUnits);
            if (this.getCycles() == 0) {
                this.setCycles(1);
            }
        } else {
            this.fExtension = EXTENSION_DEFAULT;
        }
    }

    public boolean isAvailable(Hardware hardware, List errorList) {
        ErrorInfo err;
        boolean result = super.isAvailable(hardware, errorList);
        if ((this.getParamTime().isReference() || this.getBreakTime().isReference()) && !hardware.supports("WipingRelayPEC_ref")) {
            errorList.add(new ErrorInfo(this, Language.getString("error.hardware.referenceNotSupported", "The reference is not supported by the device %.", hardware.getLocalizedPath() + hardware.getLocalizedName()), hardware));
            result &= false;
        }
        if (this.getBreakTimer().getParamTime().getMilliseconds() > 0L && !hardware.supports(EXTENSION_R_WARNING)) {
            result = false;
            err = new ErrorInfo(this, "error.convert.wipingPEC.breakTime", hardware);
            errorList.add(err);
        }
        if (this.getCycles() > 1 && !hardware.supports(EXTENSION_R_WARNING)) {
            result = false;
            err = new ErrorInfo(this, "error.convert.wipingPEC.cycles", hardware);
            errorList.add(err);
        }
        return result;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fBreakTimer);
        dw.writeInt(this.fCycles);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fBreakTimer = (Timer)dr.readStorable();
        this.fCycles = dr.readInt();
    }

    public TimeUnit getPassedTime() {
        return this.getCurrentTimer().getPassedTime();
    }

    public int getBreakTimeBase() {
        return Util.getTimeBase(this.getBreakTimer().getParamTime());
    }

    public int getTaTimeBase() {
        return Util.getTimeBase(this.getPassedTime());
    }
}

